/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class ClockClientScreenModule
implements IClientScreenModule<IModuleData> {
    private int color = 0xFFFFFF;
    private String line = "";
    private boolean large = false;

    public IClientScreenModule.TransformMode getTransformMode() {
        return this.large ? IClientScreenModule.TransformMode.TEXTLARGE : IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return this.large ? 20 : 10;
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, IModuleRenderHelper renderHelper, Font fontRenderer, int currenty, IModuleData screenData, ModuleRenderInfo renderInfo) {
        int y;
        int xoffset;
        Minecraft minecraft = Minecraft.m_91087_();
        long time = minecraft.f_91073_.m_46467_();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        String timeString = String.format(Locale.ENGLISH, "%02d:%02d", hour, minute);
        if (this.large) {
            xoffset = 4;
            y = currenty / 2 + 1;
        } else {
            xoffset = 7;
            y = currenty;
        }
        renderHelper.renderText(matrixStack, buffer, xoffset, y, this.color, renderInfo, this.line + " " + timeString);
    }

    public void mouseClick(Level world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.m_128461_("text");
            this.color = tagCompound.m_128441_("color") ? tagCompound.m_128451_("color") : 0xFFFFFF;
            this.large = tagCompound.m_128471_("large");
        }
    }

    public boolean needsServerData() {
        return false;
    }
}

